/*
 *  LICENSE:
 *  Copyright (c) 2008 Freescale Semiconductor
 *  
 *  Permission is hereby granted, free of charge, to any person 
 *  obtaining a copy of this software and associated documentation 
 *  files (the "Software"), to deal in the Software without 
 *  restriction, including without limitation the rights to use, 
 *  copy, modify, merge, publish, distribute, sublicense, and/or 
 *  sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following 
 *  conditions:
 *  
 *  The above copyright notice and this permission notice 
 *  shall be included in all copies or substantial portions 
 *  of the Software.
 *  
 *  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 *  
 *
 *  File: $Id: firdata.h,v 1.4 2008/08/01 20:57:20 b17778 Exp $
 *
 */


#define BUFFER_COUNT 200
#define NUMBER_COEF 41
#define NUMBER_STAGES 40 //must be NUMBER_COEF - 1 

//define static arrays
__accum myStaticInput[BUFFER_COUNT]= {
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};
__accum myStaticOutput[BUFFER_COUNT]= {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};
__fixed myStaticCoefficients[NUMBER_COEF] = {
	-0.0151706515
,	-0.015092386
,	-0.014171206
,	-0.012355922
,	-0.009626273
,	-0.0059949867
,	-0.0015085938
,	0.0037530875
,	0.009678808
,	0.016129024
,	0.022940231
,	0.0299303
,	0.03690467
,	0.04366313
,	0.050006926
,	0.055745896
,	0.060705435
,	0.06473288
,	0.06770317
,	0.06952346
,	0.07013665
,	0.06952346
,	0.06770317
,	0.06473288
,	0.060705435
,	0.055745896
,	0.050006926
,	0.04366313
,	0.03690467
,	0.0299303
,	0.022940231
,	0.016129024
,	0.009678808
,	0.0037530875
,	-0.0015085938
,	-0.0059949867
,	-0.009626273
,	-0.012355922
,	-0.014171206
,	-0.015092386
,	-0.0151706515};

__accum myStaticRegister[NUMBER_STAGES] = {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

//create the dynamic algorithm entities
__aacFirInput myDynInput = myStaticInput;
__aacFirInput myDynOutput = myStaticOutput;
__sFirState myDynState= { NUMBER_STAGES, 0, myStaticRegister };
__sFirParams myDynParams = { NUMBER_COEF, myStaticCoefficients};
